<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <title>مراقب أجهزة محطة البنزين</title>
        <meta name="csrf-token" content="{{ csrf_token() }}">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            padding: 20px;
        }
        .connected {
            color: green;
        }
        .disconnected {
            color: red;
        }
        .pts-info {
            background-color: #f8f9fa;
            padding: 10px;
            margin: 10px 0;
            border-radius: 5px;
        }
        .device-details {
            margin-top: 10px;
        }
        .modal-dialog-scrollable {
            max-height: 80vh;
        }
        .receipt-item {
            border-bottom: 1px solid #eee;
            padding: 10px 0;
        }
        .tank-info {
            background-color: #e9ecef;
            padding: 10px;
            margin: 5px 0;
            border-radius: 4px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="text-center mb-4">مراقب أجهزة محطة البنزين</h1>
        
        <div class="row mb-3">
            <div class="col">
                <button id="refreshBtn" class="btn btn-primary">تحديث</button>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>معرف الجهاز</th>
                        <th>الرقم التسلسلي</th>
                        <th>عنوان MAC</th>
                        <th>الحالة</th>
                        <th>آخر اتصال</th>
                        <th>معلومات PTS</th>
                        <th>الإجراءات</th>
                    </tr>
                </thead>
                <tbody id="devicesTable">
                </tbody>
            </table>
        </div>

        <div id="statusMessage" class="alert alert-info mt-3" style="display: none;"></div>
    </div>

    <!-- إضافة النوافذ المنبثقة -->
    <div class="modal fade" id="receiptsModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">الفواتير</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="receiptsContainer">
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="tankModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">معلومات الخزانات</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="tankContainer">
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="priceModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">تعديل الأسعار</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="priceForm">
                        <div class="mb-3">
                            <label class="form-label">بنزين 91</label>
                            <input type="number" class="form-control" id="price91" step="0.01">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">بنزين 95</label>
                            <input type="number" class="form-control" id="price95" step="0.01">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">ديزل</label>
                            <input type="number" class="form-control" id="priceDiesel" step="0.01">
                        </div>
                        <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- إضافة نافذة منبثقة جديدة للأوامر المخصصة -->
    <div class="modal fade" id="customCommandModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">إرسال أمر مخصص</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="customCommandForm">
                        <div class="mb-3">
                            <label class="form-label">الأمر</label>
                            <input type="text" class="form-control" id="customCommand" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">المعطيات (JSON)</label>
                            <textarea class="form-control" id="commandData" rows="4" placeholder='{
    "key": "value"
}'></textarea>
                        </div>
                        <div id="commandResponse" class="alert alert-info" style="display: none;"></div>
                        <button type="submit" class="btn btn-primary">إرسال</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Update baseUrl to include api prefix
        const baseUrl = window.location.hostname === 'localhost' ? '' : '/laravel-pts/public';
        
        // Add CSRF token to all fetch requests
        const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
        
        function fetchWithToken(url, options = {}) {
            const fullUrl = `${baseUrl}${url}`;
            options.headers = {
                ...options.headers,
                'X-CSRF-TOKEN': csrfToken,
                'Accept': 'application/json'
            };
            
            // Remove Content-Type for GET requests
            if (!options.method || options.method === 'GET') {
                delete options.headers['Content-Type'];
            }

            console.log('Request URL:', fullUrl);
            console.log('Request Options:', options);

            return fetch(fullUrl, options)
                .then(async response => {
                    const contentType = response.headers.get('content-type');
                    const text = await response.text();
                    
                    console.log('Response Content-Type:', contentType);
                    console.log('Raw Response:', text);

                    // Check if response is empty
                    if (!text || text.trim() === '') {
                        return { status: 'error', message: 'Empty response from server' };
                    }

                    // Only try to parse JSON if content-type is application/json
                    if (contentType && contentType.includes('application/json')) {
                        try {
                            return JSON.parse(text);
                        } catch (e) {
                            console.error('JSON Parse Error:', e);
                            throw new Error('Invalid JSON response');
                        }
                    }

                    // If not JSON, throw error with response text
                    throw new Error(`Unexpected response type: ${contentType}. Response: ${text}`);
                });
        }

        let updateTimer;
        const UPDATE_INTERVAL = 10000; // 10 seconds

        function updateDevices() {
            fetchWithToken('/api/devices')
                .then(response => {
                    if (response.status === 'success' && Array.isArray(response.data)) {
                        const devices = response.data;
                        const tableBody = document.getElementById('devicesTable');
                        tableBody.innerHTML = '';
                        
                        devices.forEach(device => {
                            const row = document.createElement('tr');
                            const ptsInfo = device.pts_info || {};
                            const fuelGrades = ptsInfo.fuel_grades || [];
                            
                            const fuelPricesHtml = fuelGrades.map(grade => `
                                <div>${grade.Name}: ${grade.Price} ريال</div>
                            `).join('');
                            
                            row.innerHTML = `
                                <td>${device.device_id}</td>
                                <td>${device.serial_number}</td>
                                <td>${device.mac_address}</td>
                                <td class="${device.status === 'متصل' ? 'connected' : 'disconnected'}">${device.status}</td>
                                <td>${new Date(device.last_seen).toLocaleString('ar-SA')}</td>
                                <td>
                                    <div class="pts-info">
                                        <strong>معلومات PTS:</strong>
                                        <div class="device-details">
                                            <div>نوع الجهاز: ${ptsInfo.device_type}</div>
                                            <div>إصدار البرنامج: ${ptsInfo.firmware_version}</div>
                                            <div>حالة التشغيل: ${ptsInfo.operation_status}</div>
                                            ${ptsInfo.battery ? `<div>البطارية: ${ptsInfo.battery}V</div>` : ''}
                                            ${ptsInfo.temperature ? `<div>الحرارة: ${ptsInfo.temperature}°C</div>` : ''}
                                            <div class="fuel-prices">
                                                <strong>أسعار الوقود:</strong>
                                                ${fuelPricesHtml}
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <button class="btn btn-danger btn-sm" 
                                                onclick="disconnectDevice('${device.device_id}')"
                                                ${device.status === 'غير متصل' ? 'disabled' : ''}>
                                            قطع الاتصال
                                        </button>
                                        <button class="btn btn-info btn-sm ms-2" 
                                                onclick="requestPTSInfo('${device.device_id}')"
                                                ${device.status === 'غير متصل' ? 'disabled' : ''}>
                                            تحديث PTS
                                        </button>
                                        <button class="btn btn-success btn-sm ms-2"
                                                onclick="showReceipts('${device.device_id}')"
                                                ${device.status === 'غير متصل' ? 'disabled' : ''}>
                                            الفواتير
                                        </button>
                                        <button class="btn btn-warning btn-sm ms-2"
                                                onclick="showTankInfo('${device.device_id}')"
                                                ${device.status === 'غير متصل' ? 'disabled' : ''}>
                                            الخزانات
                                        </button>
                                        <button class="btn btn-primary btn-sm ms-2"
                                                onclick="showPriceModal('${device.device_id}')"
                                                ${device.status === 'غير متصل' ? 'disabled' : ''}>
                                            الأسعار
                                        </button>
                                        <button class="btn btn-secondary btn-sm ms-2"
                                                onclick="showCustomCommandModal('${device.device_id}')"
                                                ${device.status === 'غير متصل' ? 'disabled' : ''}>
                                            أمر مخصص
                                        </button>
                                    </div>
                                </td>
                            `;
                            tableBody.appendChild(row);
                        });
                    }
                })
                .catch(error => {
                    console.error('Update error:', error);
                    showStatus('خطأ في تحديث البيانات: ' + error.message, 'danger');
                });
        }

        function startAutoUpdate() {
            updateDevices();
            clearInterval(updateTimer);
            updateTimer = setInterval(updateDevices, UPDATE_INTERVAL);
        }

        function disconnectDevice(deviceId) {
            fetchWithToken(`/api/disconnect/${deviceId}`, { method: 'POST' })
                .then(response => response.json())
                .then(data => {
                    showStatus(data.message, data.status === 'success' ? 'success' : 'danger');
                    updateDevices();
                })
                .catch(error => showStatus('خطأ في قطع الاتصال', 'danger'));
        }

        function requestPTSInfo(deviceId) {
            fetchWithToken(`/api/command/${deviceId}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    command: 'getPTSInfo'
                })
            })
            .then(response => response.json())
            .then(data => {
                showStatus(data.message, data.status === 'success' ? 'success' : 'danger');
                if (data.status === 'success') {
                    setTimeout(updateDevices, 1000); // تحديث بعد ثانية واحدة
                }
            })
            .catch(error => showStatus('خطأ في طلب معلومات PTS', 'danger'));
        }

        function showStatus(message, type) {
            const statusDiv = document.getElementById('statusMessage');
            statusDiv.textContent = message;
            statusDiv.className = `alert alert-${type} mt-3`;
            statusDiv.style.display = 'block';
            
            if (type !== 'danger') {
                setTimeout(() => {
                    statusDiv.style.display = 'none';
                }, 3000);
            }
        }

        // تحسين معالجة الأحداث
        document.addEventListener('DOMContentLoaded', () => {
            document.getElementById('refreshBtn').addEventListener('click', () => {
                updateDevices();
                showStatus('جاري تحديث البيانات...', 'info');
            });
            
            startAutoUpdate();
        });

        // دوال جديدة للتعامل مع الوظائف الجديدة
        function showReceipts(deviceId) {
            fetchWithToken(`/api/receipts/${deviceId}`)
                .then(response => response.json())
                .then(data => {
                    const container = document.getElementById('receiptsContainer');
                    container.innerHTML = data.receipts.map(receipt => `
                        <div class="receipt-item">
                            <h6>رقم الفاتورة: ${receipt.id}</h6>
                            <p>التاريخ: ${new Date(receipt.timestamp).toLocaleString('ar-SA')}</p>
                            <p>المبلغ: ${receipt.amount} ريال</p>
                            <p>نوع الوقود: ${receipt.fuel_type}</p>
                            <p>الكمية: ${receipt.volume} لتر</p>
                        </div>
                    `).join('');
                    new bootstrap.Modal(document.getElementById('receiptsModal')).show();
                })
                .catch(error => showStatus('خطأ في جلب الفواتير', 'danger'));
        }

        function showTankInfo(deviceId) {
            fetchWithToken(`/api/tank-info/${deviceId}`)
                .then(response => response.json())
                .then(data => {
                    const container = document.getElementById('tankContainer');
                    container.innerHTML = data.tanks.map(tank => `
                        <div class="tank-info">
                            <h6>خزان ${tank.id}</h6>
                            <p>المنتج: ${tank.product}</p>
                            <p>المستوى: ${tank.level}%</p>
                            <p>الحجم المتبقي: ${tank.volume} لتر</p>
                        </div>
                    `).join('');
                    new bootstrap.Modal(document.getElementById('tankModal')).show();
                })
                .catch(error => showStatus('خطأ في جلب معلومات الخزانات', 'danger'));
        }

        function showPriceModal(deviceId) {
            // عرض النافذة المنبثقة مع الأسعار الحالية
            fetchWithToken(`/api/prices/${deviceId}`)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('price91').value = data.prices.p91;
                    document.getElementById('price95').value = data.prices.p95;
                    document.getElementById('priceDiesel').value = data.prices.diesel;
                    
                    const modal = new bootstrap.Modal(document.getElementById('priceModal'));
                    modal.show();
                    
                    // تحديث معالج النموذج
                    document.getElementById('priceForm').onsubmit = (e) => {
                        e.preventDefault();
                        updatePrices(deviceId);
                    };
                })
                .catch(error => showStatus('خطأ في جلب الأسعار', 'danger'));
        }

        function updatePrices(deviceId) {
            const prices = {
                p91: parseFloat(document.getElementById('price91').value),
                p95: parseFloat(document.getElementById('price95').value),
                diesel: parseFloat(document.getElementById('priceDiesel').value)
            };

            fetchWithToken(`/api/prices/${deviceId}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(prices)
            })
            .then(response => response.json())
            .then(data => {
                showStatus(data.message, data.status === 'success' ? 'success' : 'danger');
                if (data.status === 'success') {
                    bootstrap.Modal.getInstance(document.getElementById('priceModal')).hide();
                }
            })
            .catch(error => showStatus('خطأ في تحديث الأسعار', 'danger'));
        }

        // إضافة الدوال الجديدة قبل نهاية ملف السكريبت
        function showCustomCommandModal(deviceId) {
            // تنظيف النموذج
            document.getElementById('customCommand').value = '';
            document.getElementById('commandData').value = '';
            document.getElementById('commandResponse').style.display = 'none';
            
            const modal = new bootstrap.Modal(document.getElementById('customCommandModal'));
            
            // إضافة معالج الحدث للنموذج
            const form = document.getElementById('customCommandForm');
            form.onsubmit = function(e) {
                e.preventDefault();
                sendCustomCommand(deviceId);
            };
            
            modal.show();
        }

        function sendCustomCommand(deviceId) {
            const command = document.getElementById('customCommand').value;
            const responseDiv = document.getElementById('commandResponse');
            let commandData = {};
            
            try {
                const dataText = document.getElementById('commandData').value.trim();
                if (dataText) {
                    commandData = JSON.parse(dataText);
                }

                // تسجيل البيانات للتشخيص
                console.log('Sending custom command:', {
                    deviceId,
                    command,
                    data: commandData
                });
                
                fetchWithToken(`/api/command/${deviceId}`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        command: "custom",
                        command_type: command,
                        data: commandData
                    })
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error(`HTTP error! status: ${response.status}`);
                    }
                    console.log('Response received:', response);
                    return response.json();
                })
                .then(data => {
                    console.log('Command response:', data);
                    responseDiv.textContent = data.message;
                    responseDiv.className = `alert alert-${data.status === 'success' ? 'success' : 'danger'}`;
                    responseDiv.style.display = 'block';

                    if (data.status === 'success') {
                        setTimeout(() => {
                            updateDevices();
                        }, 1000);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    responseDiv.textContent = `خطأ في إرسال الأمر: ${error.message}`;
                    responseDiv.className = 'alert alert-danger';
                    responseDiv.style.display = 'block';
                });
            } catch (error) {
                console.error('JSON Parse Error:', error);
                responseDiv.textContent = 'خطأ في تنسيق JSON';
                responseDiv.className = 'alert alert-danger';
                responseDiv.style.display = 'block';
            }
        }

        function showCommandResponse(message, type) {
            const responseDiv = document.getElementById('commandResponse');
            responseDiv.textContent = message;
            responseDiv.className = `alert alert-${type}`;
            responseDiv.style.display = 'block';
            
            // إضافة لوج في وحدة التحكم للمساعدة في التشخيص
            console.log('Command Response:', { message, type });
        }
    </script>
</body>
</html>